<?php
// export_bookings.php
session_start();
require_once 'config.php';

if (!isAdminLoggedIn()) {
    header('Location: admin_login.php');
    exit;
}

// Get filter parameters (same as dashboard)
$status_filter = $_GET['status'] ?? 'all';
$search_term = $_GET['search'] ?? '';
$date_from = $_GET['date_from'] ?? '';
$date_to = $_GET['date_to'] ?? '';

// Build query (same as dashboard)
$query = "
    SELECT b.*, 
           GROUP_CONCAT(DISTINCT br.room_name) as rooms,
           GROUP_CONCAT(DISTINCT bn.nature_type) as event_nature
    FROM bookings b
    LEFT JOIN booking_rooms br ON b.id = br.booking_id
    LEFT JOIN booking_nature bn ON b.id = bn.booking_id
    WHERE 1=1
";

$params = [];

if ($status_filter !== 'all') {
    $query .= " AND b.status = ?";
    $params[] = $status_filter;
}

if (!empty($search_term)) {
    $query .= " AND (b.organization_name LIKE ? OR b.event_name LIKE ? OR b.representative_name LIKE ?)";
    $search_like = "%$search_term%";
    $params[] = $search_like;
    $params[] = $search_like;
    $params[] = $search_like;
}

if (!empty($date_from)) {
    $query .= " AND DATE(b.submission_date) >= ?";
    $params[] = $date_from;
}

if (!empty($date_to)) {
    $query .= " AND DATE(b.submission_date) <= ?";
    $params[] = $date_to;
}

$query .= " GROUP BY b.id ORDER BY b.submission_date DESC";

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$bookings = $stmt->fetchAll();

// Set headers for download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="cedi_bookings_' . date('Y-m-d') . '.csv"');

// Create output stream
$output = fopen('php://output', 'w');

// Add CSV headers
fputcsv($output, [
    'ID',
    'Organization',
    'Event Name',
    'Representative',
    'Phone',
    'Email',
    'Event Dates',
    'Start Time',
    'End Time',
    'Participants',
    'Rooms',
    'Event Nature',
    'Status',
    'Submission Date'
]);

// Add data
foreach ($bookings as $booking) {
    fputcsv($output, [
        $booking['id'],
        $booking['organization_name'],
        $booking['event_name'],
        $booking['representative_name'],
        $booking['phone'],
        $booking['email'],
        $booking['event_dates'],
        $booking['start_time'],
        $booking['end_time'],
        $booking['max_participants'],
        $booking['rooms'],
        $booking['event_nature'],
        $booking['status'],
        $booking['submission_date']
    ]);
}

fclose($output);
exit;