<?php
// admin_management.php - Let's add debug info
session_start();
require_once 'config.php';

echo "<!-- DEBUG: Starting admin_management.php -->";
echo "<!-- Session role: " . ($_SESSION['admin_role'] ?? 'NOT SET') . " -->";
echo "<!-- isSuperAdmin(): " . (isSuperAdmin() ? 'TRUE' : 'FALSE') . " -->";

// Check if user is logged in
if (!isAdminLoggedIn()) {
    echo "<!-- DEBUG: Redirecting to login - not logged in -->";
    header('Location: admin_login.php');
    exit;
}

// Only super admins can access admin management
if (!isSuperAdmin()) {
    echo "<!-- DEBUG: Redirecting to dashboard - not super admin -->";
    echo "<!-- Current role: " . ($_SESSION['admin_role'] ?? 'NOT SET') . " -->";
    header('Location: admin_dashboard.php');
    exit;
}

echo "<!-- DEBUG: User is super admin, showing management page -->";

// Rest of your admin management code...
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Your existing POST handling code...
}

$admins = getAllAdmins();
$current_admin_id = $_SESSION['admin_id'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Admins - CEDI Conference Centre</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* Your existing CSS styles */
        body {
            font-family: Arial, sans-serif;
            background: #f5f6f8;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 2px solid #e9ecef;
        }
        h1 {
            color: #0056b3;
            margin: 0;
        }
        .btn {
            padding: 10px 20px;
            background: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        .btn:hover {
            background: #218838;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
        }
        .table th, .table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .table th {
            background: #f8f9fa;
            font-weight: 600;
        }
        .badge {
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        .badge-super { background: #fff3cd; color: #856404; }
        .badge-admin { background: #d1edff; color: #0056b3; }
        .badge-active { background: #d4edda; color: #155724; }
        .badge-inactive { background: #f8d7da; color: #721c24; }
        .actions {
            display: flex;
            gap: 5px;
        }
        .btn-sm {
            padding: 6px 12px;
            font-size: 0.8rem;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .btn-warning { background: #ffc107; color: black; }
        .btn-danger { background: #dc3545; color: white; }
        .current-user {
            background: #e7f3ff;
        }
    </style>
</head>
<body>
    <?php include 'admin_header.php'; ?>
    
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-users-cog"></i> Admin Management</h1>
            <a href="create_admin.php" class="btn">
                <i class="fas fa-user-plus"></i> Add New Admin
            </a>
        </div>

        <table class="table">
            <thead>
                <tr>
                    <th>Username</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($admins as $admin): ?>
                <tr class="<?php echo $admin['id'] == $current_admin_id ? 'current-user' : ''; ?>">
                    <td>
                        <?php echo htmlspecialchars($admin['username']); ?>
                        <?php if ($admin['id'] == $current_admin_id): ?>
                            <br><small style="color: #0056b3;">(You - <?php echo $_SESSION['admin_role'] ?? 'unknown'; ?>)</small>
                        <?php endif; ?>
                    </td>
                    <td><?php echo htmlspecialchars($admin['full_name']); ?></td>
                    <td><?php echo htmlspecialchars($admin['email']); ?></td>
                    <td>
                        <span class="badge badge-<?php echo $admin['role'] === 'super_admin' ? 'super' : 'admin'; ?>">
                            <?php echo $admin['role']; ?>
                        </span>
                    </td>
                    <td>
                        <span class="badge badge-<?php echo $admin['is_active'] ? 'active' : 'inactive'; ?>">
                            <?php echo $admin['is_active'] ? 'Active' : 'Inactive'; ?>
                        </span>
                    </td>
                    <td><?php echo date('M j, Y', strtotime($admin['created_at'])); ?></td>
                    <td>
                        <div class="actions">
                            <?php if ($admin['id'] != $current_admin_id): ?>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="admin_id" value="<?php echo $admin['id']; ?>">
                                    <input type="hidden" name="is_active" value="<?php echo $admin['is_active']; ?>">
                                    <button type="submit" name="toggle_status" class="btn-sm btn-warning">
                                        <?php echo $admin['is_active'] ? 'Deactivate' : 'Activate'; ?>
                                    </button>
                                </form>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="admin_id" value="<?php echo $admin['id']; ?>">
                                    <button type="submit" name="delete_admin" class="btn-sm btn-danger" 
                                            onclick="return confirm('Delete <?php echo htmlspecialchars($admin['username']); ?>?')">
                                        Delete
                                    </button>
                                </form>
                            <?php else: ?>
                                <span style="color: #666;">Current session</span>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>