<?php
// admin_header.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once 'config.php';

if (!isAdminLoggedIn()) {
    header('Location: admin_login.php');
    exit;
}

$adminInfo = getAdminInfo();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - CEDI Conference Centre</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #0056b3;
            --secondary: #f8f9fa;
            --accent: #ffc107;
            --success: #28a745;
            --danger: #dc3545;
            --dark: #343a40;
        }

        .admin-header {
            background: linear-gradient(135deg, var(--primary), #003d82);
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .admin-nav {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .admin-brand {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .admin-brand i {
            font-size: 2rem;
        }

        .admin-brand h1 {
            font-size: 1.8rem;
            font-weight: 600;
        }

        .admin-actions {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: var(--accent);
            color: #000;
        }

        .btn-primary:hover {
            background: #e0a800;
            transform: translateY(-2px);
        }

        .btn-outline {
            background: transparent;
            border: 2px solid white;
            color: white;
        }

        .btn-outline:hover {
            background: white;
            color: var(--primary);
        }

        .admin-info {
            display: flex;
            align-items: center;
            gap: 10px;
            color: white;
        }

        .role-badge {
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.7rem;
            font-weight: 600;
            text-transform: uppercase;
            border: 1px solid rgba(255,255,255,0.3);
        }

        .role-super_admin {
            background: rgba(255, 193, 7, 0.2);
            color: #ffc107;
        }

        .role-admin {
            background: rgba(13, 110, 253, 0.2);
            color: #6ea8fe;
        }

        @media (max-width: 768px) {
            .admin-nav {
                flex-direction: column;
                gap: 15px;
            }
            
            .admin-actions {
                flex-wrap: wrap;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <header class="admin-header">
        <nav class="admin-nav">
            <div class="admin-brand">
                <i class="fas fa-university"></i>
                <h1>CEDI Conference Centre - Admin Dashboard</h1>
            </div>
            <div class="admin-actions">
                <div class="admin-info">
                    <i class="fas fa-user-shield"></i>
                    <span>Welcome, <?php echo htmlspecialchars($adminInfo['username'] ?? 'Admin'); ?></span>
                    <span class="role-badge role-<?php echo $adminInfo['role'] ?? 'admin'; ?>">
                        <?php echo $adminInfo['role'] ?? 'admin'; ?>
                    </span>
                </div>
                
                <a href="export_bookings.php" class="btn btn-outline">
                    <i class="fas fa-download"></i> Export Bookings
                </a>
                
                <?php if (isSuperAdmin()): ?>
                <a href="admin_management.php" class="btn btn-outline">
                    <i class="fas fa-users-cog"></i> Manage Admins
                </a>
                <?php endif; ?>
                 
                <a href="admin_logout.php" class="btn btn-primary">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </nav>
    </header>
</body>
</html>